% IRF for different lambdas

clear
clc
addpath ./functions/

rng(1); % Set seed

load ../../'Estimation Results'/Benchmark_Model.mat

var_names   = {'a' 'u' 'p' 'prod_n' 'prod_o' 'theta_n' 'theta_o' 'F_n' 'F_o' 'I_n' 'I_o' 'Y' 'L' 'K' 'C' 'r'};
shock_names = {'a' 'u'};

%% Save IRF for benchmark specification
cd ./dynare_codes/
[IRF_a, IRF_u] = IRF_series(parameters);

save ../mat_files/IRFs IRF_a IRF_u

%% Save IRF for lambda=1 specification

parameters(5) = 1;
[IRF_a, IRF_u] = IRF_series(parameters);

save ../mat_files/IRFs_l1 IRF_a IRF_u
cd ../
%% Plot IRFs
clear
clc

load ./mat_files/IRFs_l1.mat

IRF_a_l = IRF_a;
IRF_u_l = IRF_u;

load ./mat_files/IRFs.mat

time    = 1:20;
lw      = 5;
fs      = 26;
fn      = 'palatino';

%% TFP Shock
hfig    = figure('color', 'w');
pos     = get(hfig,'position');
set(hfig,'position',pos.*[.5 1 2 2])

subplot(2, 2, 1), hold on
plot(time, IRF_a.I_n(time), 'linewidth', lw)
plot(time, IRF_a_l.I_n(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Non-OPEC investment (I)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(2, 2, 2), hold on
plot(time, IRF_a.I_o(time), 'linewidth', lw)
plot(time, IRF_a_l.I_o(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC investment (I)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
l = legend('$\mathbf{\lambda = 0.08}$', '$\mathbf{\lambda = 1}$', 'interpreter', 'latex', 'location', 'southeast', 'fontweight', 'bold', 'fontsize', 26);

subplot(2, 2, 3), hold on
plot(time, [0, IRF_a.F_n(time(1:end-1))], 'linewidth', lw)
plot(time, [0, IRF_a_l.F_n(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Non-OPEC oil reserves (R)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;


subplot(2, 2, 4), hold on
plot(time, [0, IRF_a.F_o(time(1:end-1))], 'linewidth', lw)
plot(time, [0, IRF_a_l.F_o(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC oil reserves (R)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;


print('../../Figures/Figure_3','-dpng')
